package cn.com.duiba.duiba.qutui.center.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName Assert.java
 * @Description 断言类
 * @createTime 2021年03月16日 15:46:00
 */
@Slf4j
public class Assert {

    public static void isBlank(String str, ErrorCode code, String errorMsg) throws BizException {
        isTrue(StringUtils.isBlank(str), code, errorMsg);
    }

    public static void isNotBlank(String str, ErrorCode code, String errorMsg) throws BizException {
        isTrue(StringUtils.isNotBlank(str), code, errorMsg);
    }

    public static void isEmpty(String str, ErrorCode code, String errorMsg) throws BizException {
        isTrue(StringUtils.isEmpty(str), code, errorMsg);
    }

    public static void isNotEmpty(String str, ErrorCode code, String errorMsg) throws BizException {
        isTrue(StringUtils.isNotEmpty(str), code, errorMsg);
    }

    public static void isNotNull(Object o, ErrorCode code, String errorMsg) throws BizException {
        isTrue(o != null, code, errorMsg);
    }

    public static void isNull(Object o, ErrorCode code, String errorMsg) throws BizException {
        isTrue(o == null, code, errorMsg);
    }

    public static void isNotEmpty(Collection c, ErrorCode code, String errorMsg) throws BizException {
        isTrue(CollectionUtils.isNotEmpty(c), code, errorMsg);
    }

    public static void isEmpty(Collection c, ErrorCode code, String errorMsg) throws BizException {
        isTrue(CollectionUtils.isEmpty(c), code, errorMsg);
    }

    public static void isMapNotEmpty(Map m, ErrorCode code, String errorMsg) throws BizException {
        isTrue(m != null && !m.isEmpty(), code, errorMsg);
    }

    public static void isMapEmpty(Map m, ErrorCode code, String errorMsg) throws BizException {
        isTrue(m == null || m.isEmpty(), code, errorMsg);
    }

    public static void isTrue(boolean as, ErrorCode code, String errorMsg) throws BizException {
        if (code == null) {
            code = ErrorCode.ERROR;
        }
        if (!as) {
            log.info("ErrorCode = {},errorMsg = {}",code,errorMsg);
            throw new BizException(errorMsg).withCode(code.getCode());
        }
    }
}
