/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.qutui.center.api.enums;

import cn.com.duiba.duiba.qutui.center.api.enums.OaTargetEnum;
import java.util.Objects;

public enum OATypeEnum {
    OPEN_PL(1, null, "\u7b2c\u4e09\u65b9\u670d\u52a1\u5e73\u53f0"),
    OPEN_MP(2, OaTargetEnum.MP.getCode(), "\u7b2c\u4e09\u65b9\u670d\u52a1\u5e73\u53f0\u670d\u52a1\u7684\u5c0f\u7a0b\u5e8f"),
    OA(3, OaTargetEnum.OA.getCode(), "\u81ea\u6709\u516c\u4f17\u53f7"),
    OPEN_OA(4, OaTargetEnum.OA.getCode(), "\u7b2c\u4e09\u65b9\u670d\u52a1\u5e73\u53f0\u670d\u52a1\u7684\u516c\u4f17\u53f7"),
    OPEN_SUITE(5, OaTargetEnum.SUITE.getCode(), "\u4e09\u65b9\u5957\u4ef6\u5e94\u7528");

    private final Integer type;
    private final Integer target;
    private final String desc;

    private OATypeEnum(Integer type, Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public Integer getTarget() {
        return this.target;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e : OATypeEnum.values()) {
            if (!Objects.equals(type, e.getType())) continue;
            return e;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684oa\u7c7b\u578b");
    }

    public static boolean isOa(Integer type) {
        return OA.getType().equals(type) || OPEN_OA.getType().equals(type);
    }

    public static boolean isMp(Integer type) {
        return OPEN_MP.getType().equals(type);
    }
}

