package cn.com.duiba.duiba.qutui.center.api.remoteservice.setup;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupMpDto;

import java.util.List;

/**
* 机构-微信主体关联表 RemoteService
* @author xiaotian
* 2021-4-14 17:20:30
*/
@AdvancedFeignClient
public interface RemoteSetupMpService {
    /**
    * 新增记录
    */
	Boolean save(SetupMpDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(SetupMpDto dto);
    /**
    * 根据id获取
    */
    SetupMpDto getById(Long id);


    /**
     * 更新关系记录
     */
    Boolean batchInsert(SetupMpDto dto);

    /**
     * 获取父级机构关联关系
     * @param setupId
     * @return
     */
    List<SetupMpDto> getSetupFamilyMp(Long setupId);

    /**
     * 获取机构关联关系
     * @param setupId
     * @return
     */
    List<SetupMpDto> getSetupMp(Long setupId);
}
