package cn.com.duiba.duiba.qutui.center.api.remoteservice.staff;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.staff.StaffDto;

import java.util.List;

/**
* 员工表 RemoteService
* @author xiaotian
* 2021-3-17 18:31:47
*/
@AdvancedFeignClient
public interface RemoteStaffService {
    /**
    * 新增记录
    */
	Long save(StaffDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(StaffDto dto);
    /**
    * 根据id获取
    */
    StaffDto getById(Long id);

    /**
     * 通过userid获取员工信息
     * 这里获取有效的员工信息，一个userId可能存在多条员工数据，但是有效状态的就一条员工数据
     *
     * @param userId
     * @return
     */
    StaffDto getByUserId(Long userId);

    /**
     * 通过手机号查询员工信息
     * @param phoneNum
     * @return
     */
    List<StaffDto> getByPhoneNum(String phoneNum);

    /**
     * 通过手机号或者工号获取员工
     * @param num 手机号或者工号
     * @return
     */
    List<StaffDto> getPushTestStaff(Long setupId,String num);


}
