/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectEventDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.StaffEventGradeDto;
import cn.com.duiba.duiba.qutui.center.api.enums.EventLogStatusEnum;
import cn.com.duiba.duiba.qutui.center.api.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EventGradeDto
implements Serializable {
    private String gradeExplain;
    private String eventTxt;
    private Long eventId;
    private Double eventGrade;
    private Boolean joinPeopleNum = false;
    private String joinPeopleNumText;
    private Integer joinPeopleNumCount = 0;
    private Boolean joinNum = false;
    private String joinNumText;
    private Integer joinNumCount = 0;
    private Boolean finishJoinPeopleNum = false;
    private String finishJoinPeopleNumText;
    private Integer finishJoinPeopleNumCount = 0;
    private Boolean finishJoinNum = false;
    private String finishJoinNumText;
    private Integer finishJoinNumCount = 0;
    private Boolean isStatistical;
    private String statisticalText;
    private Integer statisticalCount = 0;

    public static EventGradeDto buildGrade(List<StaffEventGradeDto> staffEventGrades, Map<Long, Integer> eventId2StatisticalCount, Map<Long, ProjectEventDto> eventId2Dto) {
        if (CollectionUtils.isEmpty(staffEventGrades)) {
            return null;
        }
        Map<Integer, List<StaffEventGradeDto>> status2Grade = staffEventGrades.stream().collect(Collectors.groupingBy(StaffEventGradeDto::getLogStatus));
        EventGradeDto dto = new EventGradeDto();
        dto.eventId = staffEventGrades.get(0).getEventId();
        List<StaffEventGradeDto> eventGradeDtos = status2Grade.get(EventLogStatusEnum.JOIN.getCode());
        dto.joinPeopleNumCount = eventGradeDtos != null ? eventGradeDtos.size() : 0;
        dto.joinNumCount = eventGradeDtos != null ? eventGradeDtos.stream().mapToInt(StaffEventGradeDto::getCount).sum() : 0;
        eventGradeDtos = status2Grade.get(EventLogStatusEnum.FINISH.getCode());
        dto.finishJoinPeopleNumCount = eventGradeDtos != null ? eventGradeDtos.size() : 0;
        dto.finishJoinNumCount = eventGradeDtos != null ? eventGradeDtos.stream().mapToInt(StaffEventGradeDto::getCount).sum() : 0;
        dto.statisticalCount = Optional.ofNullable(eventId2StatisticalCount.get(dto.eventId)).orElse(0);
        dto.setGradeExplain(eventId2Dto.get(dto.eventId).getGradeExplain());
        return dto;
    }

    public void mergeEventGrade(EventGradeDto staffEventGradeDto) {
        if (staffEventGradeDto != null) {
            this.eventGrade = MathUtil.add(this.eventGrade, staffEventGradeDto.getEventGrade());
            this.joinPeopleNumCount = MathUtil.add(this.joinPeopleNumCount, staffEventGradeDto.getJoinPeopleNumCount());
            this.joinNumCount = MathUtil.add(this.joinNumCount, staffEventGradeDto.getJoinNumCount());
            this.finishJoinPeopleNumCount = MathUtil.add(this.finishJoinPeopleNumCount, staffEventGradeDto.getFinishJoinPeopleNumCount());
            this.finishJoinNumCount = MathUtil.add(this.finishJoinNumCount, staffEventGradeDto.getFinishJoinNumCount());
            this.statisticalCount = staffEventGradeDto.getStatisticalCount();
            this.gradeExplain = staffEventGradeDto.getGradeExplain();
        }
    }

    public EventGradeDto copy() {
        return (EventGradeDto)BeanUtils.copy((Object)this, EventGradeDto.class);
    }

    public String getGradeExplain() {
        return this.gradeExplain;
    }

    public String getEventTxt() {
        return this.eventTxt;
    }

    public Long getEventId() {
        return this.eventId;
    }

    public Double getEventGrade() {
        return this.eventGrade;
    }

    public Boolean getJoinPeopleNum() {
        return this.joinPeopleNum;
    }

    public String getJoinPeopleNumText() {
        return this.joinPeopleNumText;
    }

    public Integer getJoinPeopleNumCount() {
        return this.joinPeopleNumCount;
    }

    public Boolean getJoinNum() {
        return this.joinNum;
    }

    public String getJoinNumText() {
        return this.joinNumText;
    }

    public Integer getJoinNumCount() {
        return this.joinNumCount;
    }

    public Boolean getFinishJoinPeopleNum() {
        return this.finishJoinPeopleNum;
    }

    public String getFinishJoinPeopleNumText() {
        return this.finishJoinPeopleNumText;
    }

    public Integer getFinishJoinPeopleNumCount() {
        return this.finishJoinPeopleNumCount;
    }

    public Boolean getFinishJoinNum() {
        return this.finishJoinNum;
    }

    public String getFinishJoinNumText() {
        return this.finishJoinNumText;
    }

    public Integer getFinishJoinNumCount() {
        return this.finishJoinNumCount;
    }

    public Boolean getIsStatistical() {
        return this.isStatistical;
    }

    public String getStatisticalText() {
        return this.statisticalText;
    }

    public Integer getStatisticalCount() {
        return this.statisticalCount;
    }

    public void setGradeExplain(String gradeExplain) {
        this.gradeExplain = gradeExplain;
    }

    public void setEventTxt(String eventTxt) {
        this.eventTxt = eventTxt;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    public void setEventGrade(Double eventGrade) {
        this.eventGrade = eventGrade;
    }

    public void setJoinPeopleNum(Boolean joinPeopleNum) {
        this.joinPeopleNum = joinPeopleNum;
    }

    public void setJoinPeopleNumText(String joinPeopleNumText) {
        this.joinPeopleNumText = joinPeopleNumText;
    }

    public void setJoinPeopleNumCount(Integer joinPeopleNumCount) {
        this.joinPeopleNumCount = joinPeopleNumCount;
    }

    public void setJoinNum(Boolean joinNum) {
        this.joinNum = joinNum;
    }

    public void setJoinNumText(String joinNumText) {
        this.joinNumText = joinNumText;
    }

    public void setJoinNumCount(Integer joinNumCount) {
        this.joinNumCount = joinNumCount;
    }

    public void setFinishJoinPeopleNum(Boolean finishJoinPeopleNum) {
        this.finishJoinPeopleNum = finishJoinPeopleNum;
    }

    public void setFinishJoinPeopleNumText(String finishJoinPeopleNumText) {
        this.finishJoinPeopleNumText = finishJoinPeopleNumText;
    }

    public void setFinishJoinPeopleNumCount(Integer finishJoinPeopleNumCount) {
        this.finishJoinPeopleNumCount = finishJoinPeopleNumCount;
    }

    public void setFinishJoinNum(Boolean finishJoinNum) {
        this.finishJoinNum = finishJoinNum;
    }

    public void setFinishJoinNumText(String finishJoinNumText) {
        this.finishJoinNumText = finishJoinNumText;
    }

    public void setFinishJoinNumCount(Integer finishJoinNumCount) {
        this.finishJoinNumCount = finishJoinNumCount;
    }

    public void setIsStatistical(Boolean isStatistical) {
        this.isStatistical = isStatistical;
    }

    public void setStatisticalText(String statisticalText) {
        this.statisticalText = statisticalText;
    }

    public void setStatisticalCount(Integer statisticalCount) {
        this.statisticalCount = statisticalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventGradeDto)) {
            return false;
        }
        EventGradeDto other = (EventGradeDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$gradeExplain = this.getGradeExplain();
        String other$gradeExplain = other.getGradeExplain();
        if (this$gradeExplain == null ? other$gradeExplain != null : !this$gradeExplain.equals(other$gradeExplain)) {
            return false;
        }
        String this$eventTxt = this.getEventTxt();
        String other$eventTxt = other.getEventTxt();
        if (this$eventTxt == null ? other$eventTxt != null : !this$eventTxt.equals(other$eventTxt)) {
            return false;
        }
        Long this$eventId = this.getEventId();
        Long other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !((Object)this$eventId).equals(other$eventId)) {
            return false;
        }
        Double this$eventGrade = this.getEventGrade();
        Double other$eventGrade = other.getEventGrade();
        if (this$eventGrade == null ? other$eventGrade != null : !((Object)this$eventGrade).equals(other$eventGrade)) {
            return false;
        }
        Boolean this$joinPeopleNum = this.getJoinPeopleNum();
        Boolean other$joinPeopleNum = other.getJoinPeopleNum();
        if (this$joinPeopleNum == null ? other$joinPeopleNum != null : !((Object)this$joinPeopleNum).equals(other$joinPeopleNum)) {
            return false;
        }
        String this$joinPeopleNumText = this.getJoinPeopleNumText();
        String other$joinPeopleNumText = other.getJoinPeopleNumText();
        if (this$joinPeopleNumText == null ? other$joinPeopleNumText != null : !this$joinPeopleNumText.equals(other$joinPeopleNumText)) {
            return false;
        }
        Integer this$joinPeopleNumCount = this.getJoinPeopleNumCount();
        Integer other$joinPeopleNumCount = other.getJoinPeopleNumCount();
        if (this$joinPeopleNumCount == null ? other$joinPeopleNumCount != null : !((Object)this$joinPeopleNumCount).equals(other$joinPeopleNumCount)) {
            return false;
        }
        Boolean this$joinNum = this.getJoinNum();
        Boolean other$joinNum = other.getJoinNum();
        if (this$joinNum == null ? other$joinNum != null : !((Object)this$joinNum).equals(other$joinNum)) {
            return false;
        }
        String this$joinNumText = this.getJoinNumText();
        String other$joinNumText = other.getJoinNumText();
        if (this$joinNumText == null ? other$joinNumText != null : !this$joinNumText.equals(other$joinNumText)) {
            return false;
        }
        Integer this$joinNumCount = this.getJoinNumCount();
        Integer other$joinNumCount = other.getJoinNumCount();
        if (this$joinNumCount == null ? other$joinNumCount != null : !((Object)this$joinNumCount).equals(other$joinNumCount)) {
            return false;
        }
        Boolean this$finishJoinPeopleNum = this.getFinishJoinPeopleNum();
        Boolean other$finishJoinPeopleNum = other.getFinishJoinPeopleNum();
        if (this$finishJoinPeopleNum == null ? other$finishJoinPeopleNum != null : !((Object)this$finishJoinPeopleNum).equals(other$finishJoinPeopleNum)) {
            return false;
        }
        String this$finishJoinPeopleNumText = this.getFinishJoinPeopleNumText();
        String other$finishJoinPeopleNumText = other.getFinishJoinPeopleNumText();
        if (this$finishJoinPeopleNumText == null ? other$finishJoinPeopleNumText != null : !this$finishJoinPeopleNumText.equals(other$finishJoinPeopleNumText)) {
            return false;
        }
        Integer this$finishJoinPeopleNumCount = this.getFinishJoinPeopleNumCount();
        Integer other$finishJoinPeopleNumCount = other.getFinishJoinPeopleNumCount();
        if (this$finishJoinPeopleNumCount == null ? other$finishJoinPeopleNumCount != null : !((Object)this$finishJoinPeopleNumCount).equals(other$finishJoinPeopleNumCount)) {
            return false;
        }
        Boolean this$finishJoinNum = this.getFinishJoinNum();
        Boolean other$finishJoinNum = other.getFinishJoinNum();
        if (this$finishJoinNum == null ? other$finishJoinNum != null : !((Object)this$finishJoinNum).equals(other$finishJoinNum)) {
            return false;
        }
        String this$finishJoinNumText = this.getFinishJoinNumText();
        String other$finishJoinNumText = other.getFinishJoinNumText();
        if (this$finishJoinNumText == null ? other$finishJoinNumText != null : !this$finishJoinNumText.equals(other$finishJoinNumText)) {
            return false;
        }
        Integer this$finishJoinNumCount = this.getFinishJoinNumCount();
        Integer other$finishJoinNumCount = other.getFinishJoinNumCount();
        if (this$finishJoinNumCount == null ? other$finishJoinNumCount != null : !((Object)this$finishJoinNumCount).equals(other$finishJoinNumCount)) {
            return false;
        }
        Boolean this$isStatistical = this.getIsStatistical();
        Boolean other$isStatistical = other.getIsStatistical();
        if (this$isStatistical == null ? other$isStatistical != null : !((Object)this$isStatistical).equals(other$isStatistical)) {
            return false;
        }
        String this$statisticalText = this.getStatisticalText();
        String other$statisticalText = other.getStatisticalText();
        if (this$statisticalText == null ? other$statisticalText != null : !this$statisticalText.equals(other$statisticalText)) {
            return false;
        }
        Integer this$statisticalCount = this.getStatisticalCount();
        Integer other$statisticalCount = other.getStatisticalCount();
        return !(this$statisticalCount == null ? other$statisticalCount != null : !((Object)this$statisticalCount).equals(other$statisticalCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventGradeDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $gradeExplain = this.getGradeExplain();
        result = result * 59 + ($gradeExplain == null ? 43 : $gradeExplain.hashCode());
        String $eventTxt = this.getEventTxt();
        result = result * 59 + ($eventTxt == null ? 43 : $eventTxt.hashCode());
        Long $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : ((Object)$eventId).hashCode());
        Double $eventGrade = this.getEventGrade();
        result = result * 59 + ($eventGrade == null ? 43 : ((Object)$eventGrade).hashCode());
        Boolean $joinPeopleNum = this.getJoinPeopleNum();
        result = result * 59 + ($joinPeopleNum == null ? 43 : ((Object)$joinPeopleNum).hashCode());
        String $joinPeopleNumText = this.getJoinPeopleNumText();
        result = result * 59 + ($joinPeopleNumText == null ? 43 : $joinPeopleNumText.hashCode());
        Integer $joinPeopleNumCount = this.getJoinPeopleNumCount();
        result = result * 59 + ($joinPeopleNumCount == null ? 43 : ((Object)$joinPeopleNumCount).hashCode());
        Boolean $joinNum = this.getJoinNum();
        result = result * 59 + ($joinNum == null ? 43 : ((Object)$joinNum).hashCode());
        String $joinNumText = this.getJoinNumText();
        result = result * 59 + ($joinNumText == null ? 43 : $joinNumText.hashCode());
        Integer $joinNumCount = this.getJoinNumCount();
        result = result * 59 + ($joinNumCount == null ? 43 : ((Object)$joinNumCount).hashCode());
        Boolean $finishJoinPeopleNum = this.getFinishJoinPeopleNum();
        result = result * 59 + ($finishJoinPeopleNum == null ? 43 : ((Object)$finishJoinPeopleNum).hashCode());
        String $finishJoinPeopleNumText = this.getFinishJoinPeopleNumText();
        result = result * 59 + ($finishJoinPeopleNumText == null ? 43 : $finishJoinPeopleNumText.hashCode());
        Integer $finishJoinPeopleNumCount = this.getFinishJoinPeopleNumCount();
        result = result * 59 + ($finishJoinPeopleNumCount == null ? 43 : ((Object)$finishJoinPeopleNumCount).hashCode());
        Boolean $finishJoinNum = this.getFinishJoinNum();
        result = result * 59 + ($finishJoinNum == null ? 43 : ((Object)$finishJoinNum).hashCode());
        String $finishJoinNumText = this.getFinishJoinNumText();
        result = result * 59 + ($finishJoinNumText == null ? 43 : $finishJoinNumText.hashCode());
        Integer $finishJoinNumCount = this.getFinishJoinNumCount();
        result = result * 59 + ($finishJoinNumCount == null ? 43 : ((Object)$finishJoinNumCount).hashCode());
        Boolean $isStatistical = this.getIsStatistical();
        result = result * 59 + ($isStatistical == null ? 43 : ((Object)$isStatistical).hashCode());
        String $statisticalText = this.getStatisticalText();
        result = result * 59 + ($statisticalText == null ? 43 : $statisticalText.hashCode());
        Integer $statisticalCount = this.getStatisticalCount();
        result = result * 59 + ($statisticalCount == null ? 43 : ((Object)$statisticalCount).hashCode());
        return result;
    }

    public String toString() {
        return "EventGradeDto(gradeExplain=" + this.getGradeExplain() + ", eventTxt=" + this.getEventTxt() + ", eventId=" + this.getEventId() + ", eventGrade=" + this.getEventGrade() + ", joinPeopleNum=" + this.getJoinPeopleNum() + ", joinPeopleNumText=" + this.getJoinPeopleNumText() + ", joinPeopleNumCount=" + this.getJoinPeopleNumCount() + ", joinNum=" + this.getJoinNum() + ", joinNumText=" + this.getJoinNumText() + ", joinNumCount=" + this.getJoinNumCount() + ", finishJoinPeopleNum=" + this.getFinishJoinPeopleNum() + ", finishJoinPeopleNumText=" + this.getFinishJoinPeopleNumText() + ", finishJoinPeopleNumCount=" + this.getFinishJoinPeopleNumCount() + ", finishJoinNum=" + this.getFinishJoinNum() + ", finishJoinNumText=" + this.getFinishJoinNumText() + ", finishJoinNumCount=" + this.getFinishJoinNumCount() + ", isStatistical=" + this.getIsStatistical() + ", statisticalText=" + this.getStatisticalText() + ", statisticalCount=" + this.getStatisticalCount() + ")";
    }
}

