package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.duiba.qutui.center.api.dto.staff.StaffDto;
import com.alibaba.fastjson.JSONArray;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 职工历史业绩
 * 2021-3-22 17:56:32
 */
@Data
public class StaffGradeDto implements Serializable {

    /**
     * 总分
     */
    private Double allGrade;

    /**
     * 批次id
     */
    private String batchId;

    /**
     * json，保存每个事件的业绩
     */
    private String eventGrade;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 本机构下的排名
     */
    private Integer gradeRank;

    /**
     * id,主键，自增
     */
    private Long id;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 机构id
     */
    private Long setupId;

    /**
     * 职工id
     */
    private Long staffId;
    /**
     * 业绩计算说明
     */
    private String gradeExplain;

    public List<EventGradeDto> getEventGradeDtos() {
        return JSONArray.parseArray(eventGrade, EventGradeDto.class);
    }

    public StaffGradeDto() {
    }

    public StaffGradeDto(String batchId,Long projectId, StaffDto staffDto,
                         List<EventGradeDto> eventGradeList) {
        this.batchId = batchId;
        this.projectId = projectId;
        this.setupId = staffDto.getSetupId();
        this.staffId = staffDto.getId();
        this.eventGrade = JSONArray.toJSONString(eventGradeList);

        this.allGrade = 0D;

        for (EventGradeDto eventGradeDto : eventGradeList) {
            allGrade =eventGradeDto.getEventGrade() + allGrade;

        }
    }
}

