package cn.com.duiba.duixintong.center.api.dto.common;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 登录账号表
 * @author lizhi
 * @date 2023/5/23 2:20 PM
 */
@Data
public class LoginAccountDto implements Serializable {
    
    private static final long serialVersionUID = -1467421220670103585L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账号
     */
    private String accountNum;

    /**
     * 密码，用户实际密码MD5后以盐加密
     */
    private String accountPassword;

    /**
     * 密码盐
     */
    private String passwordSalt;

    /**
     * 账号类型：1-超级管理员，2-商家账号
     * {@link cn.com.duiba.duixintong.center.api.enums.account.AccountTypeEnum}
     */
    private Integer accountType;

    /**
     * 备注
     */
    private String accountRemark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
