package cn.com.duiba.duixintong.center.api.dto.common;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 操作记录表
 * @author kjj mybatis generator 
 * @date 2023-05-16
 */
@Data
public class OperateLogDto implements Serializable {

    private static final long serialVersionUID = 828033274565514784L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 操作所属业务名称, 比如权益、活动
     */
    private String groupName;

    /**
     * 操作类型名称, 比如新增、修改、删除
     */
    private String typeName;

    /**
     * 操作关联的数据Id, 用于检索相关日志
     */
    private Long bizId;

    /**
     * 操作人Id
     */
    private String operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 操作相关的接口路径
     */
    private String operatePath;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}