package cn.com.duiba.duixintong.center.api.param.withdraw;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author yangyukang
 */
@Data
public class WithdrawAccountParam implements Serializable {

    private static final long serialVersionUID = 1197603952782178015L;
    /**
     * 商家ID，用于商家维度分页查询，若无则不传(accountType为商家时也不传)
     */
    private Long businessId;

    /**
     * 账户ID，推荐人ID(账户类型-1)，商家ID(账户类型-2)，重客ID(账户类型-3)
     */
    private Long accountId;

    /**
     * 账户类型，1-推荐人，2-商家，3-重客
     * {@link cn.com.duiba.duixintong.center.api.enums.fund.FundAccountTypeEnum}
     */
    private Integer accountType;

    /**
     * 关联业务唯一标识
     */
    private String bizNo;

    /**
     * 提现金额(分)
     */
    private Long withdrawAmount;

    /**
     * 备注，若无则不传
     */
    private String remark;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 银行id
     */
    private Long bankId;

    /**
     * 渠道
     */
    private Integer bankChannel;

    /**
     * 提现方式，1-微信零钱，2-公对公转账
     * @see cn.com.duiba.duixintong.center.api.enums.business.BusinessWithdrawTypeEnum
     */
    private Integer withdrawType;

    /**
     * 微信零钱-微信昵称
     */
    private String nickname;

    /**
     * 微信零钱-用户姓名
     */
    private String userName;

    /**
     * 微信零钱-用户手机号
     */
    private String userPhone;

    /**
     * 微信零钱-用户提现openid
     */
    private String openId;

}
