package cn.com.duiba.duixintong.center.api.remoteservice.certificaterecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityCertificateRecordDto;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityDetailDto;
import cn.com.duiba.duixintong.center.api.dto.activity.ActivityDto;
import cn.com.duiba.duixintong.center.api.dto.activity.BusinessActivityDto;
import cn.com.duiba.duixintong.center.api.param.activity.ActivityQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/17 15:04
 */
@AdvancedFeignClient
public interface RemoteCertificateRecordService {

    /**
     * 保存凭证
     * @param activityCertificateRecordDto
     * @return
     */
    int saveActivityCertificateRecord(ActivityCertificateRecordDto activityCertificateRecordDto);

    /**
     * 根据活动id查询凭证
     * @param activityId
     * @return
     */
    List<ActivityCertificateRecordDto> queryCertificateRecordByActivityId(Long activityId);

    /**
     * 根据商家id查询凭证
     * @param businessId
     * @return
     */
    List<ActivityCertificateRecordDto> queryCertificateRecordByBusinessId(Long businessId);

}
