package cn.com.duiba.duixintong.center.api.enums.statistics;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/5/19 13:48
 */
public enum DateTypeEnum {
    HOUR("hour", "时"),
    DAY("day", "日"),
    MONTH("month", "月"),
    ALL("all", "全部"),
    ;

    private String type;
    private String desc;

    public static DateTypeEnum getByType(String type) {
        if (StringUtils.isBlank(type)) {
            return null;
        }
        DateTypeEnum[] values = DateTypeEnum.values();
        for (DateTypeEnum value : values) {
            if (Objects.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }

    DateTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
