package cn.com.duiba.duixintong.center.api.param.hologres;

import cn.com.duiba.duixintong.center.api.enums.hologres.HologresDimensionEnum;
import cn.com.duiba.duixintong.center.api.enums.hologres.HologresOperatorsEnum;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;

/**
 * 查询条件
 * @author lizhi
 */
@AllArgsConstructor
@Data
public class HologresWhereParam implements Serializable {

    private static final long serialVersionUID = -6448376594507289161L;

    /**
     * 查询条件的key
     */
    private HologresDimensionEnum key;

    /**
     * 多个值用list
     * 如果symbol = "IS_NULL" 或者 symbol = "IS_NOT_NULL"，value 不需要赋值
     */
    private Serializable value;

    /**
     * 操作符，默认是in
     */
    private HologresOperatorsEnum symbol = HologresOperatorsEnum.IN;

    public HologresWhereParam(HologresDimensionEnum key, Serializable value) {
        this.key = key;
        this.value = value;
    }

}
