package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * @Author: fss
 * @Date: 2022/1/15 09
 * @Description:
 */
public enum ItemClassifyTypeEnum {

    OBJECT("object", "实物类型"),

    COUPON("coupon", "优惠劵类型"),

    VIRTUAL("virtual", "虚拟商品类型"),

    SUPPLIER_OBJECT("supplierObject", "供应商实物类型"),

    SUPPLIER_COUPON("supplierCoupon", "供应商优惠劵类型"),

    SUPPLIER_CRYPTO_CARD("supplierCryptoCard", "供应商卡密类型(独立)"),
    ;


    private String type;

    private String desc;

    ItemClassifyTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 根据类型，反查枚举类<br/>
     * 若是没找到，返回null
     *
     * @param type 枚举类型
     * @return 枚举类
     */
    public static ItemClassifyTypeEnum getGoodsTypeEnum(int type) {
        ItemClassifyTypeEnum[] values = ItemClassifyTypeEnum.values();
        for (ItemClassifyTypeEnum value : values) {
            if (value.getType().equals(type)) {
                return value;
            }
        }

        return null;
    }
}
