/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.util;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;

public class ItemCornerTagUtils {
    private static final String CUSTOMTAGSPLITSYMBOL = ",";
    private static Joiner joiner = Joiner.on((String)",").skipNulls();
    public static final int CUSTOMTAG_NO1 = 0;
    public static final int CUSTOMTAG_NO2 = 1;

    private ItemCornerTagUtils() {
    }

    public static String getCustomTagText(Optional<AppItemDto> appItem) {
        String custom = ((AppItemDto)appItem.get()).getCustomTag();
        if (StringUtils.isBlank((String)custom)) {
            return "";
        }
        String[] ss = custom.split(CUSTOMTAGSPLITSYMBOL);
        if (ss.length == 0) {
            return "";
        }
        return ss[0];
    }

    public static String getCustomTagColor(Optional<AppItemDto> appItem) {
        String custom = ((AppItemDto)appItem.get()).getCustomTag();
        if (StringUtils.isBlank((String)custom)) {
            return "#fe4a21";
        }
        String[] ss = custom.split(CUSTOMTAGSPLITSYMBOL);
        if (ss.length < 2) {
            return "#fe4a21";
        }
        return ss[1];
    }

    public static String getCustomTag(String customTagText, String customTagColor) {
        return joiner.join((Object)customTagText, (Object)customTagColor, new Object[0]);
    }
}

