/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool.sku;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.UnitUtils;
import cn.com.duiba.goods.center.api.remoteservice.tool.sku.AbstractSkuResolver;

public class ItemSkuResolver
extends AbstractSkuResolver<ItemSkuDto, SkuAttributeNode.SkuSupplyInfo> {
    @Override
    protected ItemSkuDto toDto(Long appItemId, Long itemId, String attributeJson, SkuAttributeNode.SkuSupplyInfo skuInfo) {
        ItemSkuDto itemSku = new ItemSkuDto();
        itemSku.setItemId(itemId);
        itemSku.setAttributeJson(attributeJson);
        itemSku.setId(this.parseString2Long(skuInfo.getId()));
        itemSku.setFacePrice(UnitUtils.transformYuan2Fen(skuInfo.getFacePrice()));
        itemSku.setSalePrice(UnitUtils.transformYuan2Fen(skuInfo.getSalePrice()));
        itemSku.setCostPrice(UnitUtils.transformYuan2Fen(skuInfo.getCostPrice()));
        itemSku.setSuggestMarketPrice(UnitUtils.transformYuan2Fen(skuInfo.getSuggestMarketPrice()));
        itemSku.setPopShowPrice(UnitUtils.transformYuan2Fen(skuInfo.getPopShowPrice()));
        itemSku.setMerchantCoding(skuInfo.getMerchantCoding());
        itemSku.setRemaining(skuInfo.getRemaining());
        itemSku.setPreRemaining(skuInfo.getPreRemaining());
        itemSku.setImgUrl(skuInfo.getImgUrl());
        itemSku.setStockId(this.parseString2Long(skuInfo.getStockId()));
        itemSku.setCardLibraryId(this.parseString2Long(skuInfo.getCardLibraryId()));
        return itemSku;
    }

    @Override
    protected String getAttributeJson(ItemSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected SkuAttributeNode.SkuSupplyInfo toVo(ItemSkuDto sku) {
        SkuAttributeNode.SkuSupplyInfo skuInfo = new SkuAttributeNode.SkuSupplyInfo();
        skuInfo.setId(this.parseLong2String(sku.getId()));
        skuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        skuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        skuInfo.setCostPrice(UnitUtils.transformFen2Yuan(sku.getCostPrice()));
        skuInfo.setSuggestMarketPrice(UnitUtils.transformFen2Yuan(sku.getSuggestMarketPrice()));
        skuInfo.setPopShowPrice(UnitUtils.transformFen2Yuan(sku.getPopShowPrice()));
        skuInfo.setMerchantCoding(sku.getMerchantCoding());
        skuInfo.setImgUrl(sku.getImgUrl());
        skuInfo.setRemaining(sku.getRemaining());
        skuInfo.setPreRemaining(sku.getRemaining());
        skuInfo.setStockId(this.parseLong2String(sku.getStockId()));
        skuInfo.setCardLibraryId(this.parseLong2String(sku.getCardLibraryId()));
        return skuInfo;
    }

    @Override
    protected SkuAttributeNode.SkuSupplyInfo getSkuInfo(SkuAttributeNode<SkuAttributeNode.SkuSupplyInfo> node) {
        SkuAttributeNode.SkuSupplyInfo skuInfo = super.getSkuInfo(node);
        skuInfo.setImgUrl(node.getImgUrl());
        return skuInfo;
    }

    @Override
    protected void postNode(SkuAttributeNode<SkuAttributeNode.SkuSupplyInfo> headNode, SkuAttributeNode<SkuAttributeNode.SkuSupplyInfo> node) {
        if (node.getSkuInfo() != null) {
            if (headNode.getImgUrl() == null) {
                headNode.setImgUrl(node.getSkuInfo().getImgUrl());
            }
            node.getSkuInfo().setImgUrl(null);
        }
    }
}

