package cn.com.duiba.goods.center.api.remoteservice.enums;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;

/**
 * @Desc 属性枚举类型
 * @Author xuwei
 * @Date 2019/1/7
 */
public enum AttributeTypeEnum {
    OBJECT(1),
    COUPON(2),
    CRYPTO_CARD(3),
    VIRTUAL(4);
    private int code;

    AttributeTypeEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    /**
     * 根据商品类型获取属性枚举类型
     *
     * @param type
     * @param subType
     * @return
     */
    public static AttributeTypeEnum getByItemType(String type, Integer subType) {
        if (ItemDto.TypeObject.equals(type)) {
            return OBJECT;
        }
        if (ItemDto.TypeVirtual.equals(type)) {
            return VIRTUAL;
        }
        if (ItemDto.TypeCoupon.equals(type) && subType == CouponType.CryptoCard.getValue()) {
            return CRYPTO_CARD;
        }
        return COUPON;
    }

}
