package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by xuezhaoming on 16/5/16.
 */
public enum GoodsTypeEnum {

    DUIBA(1, "兑吧商品"),

    APP(2, "app自有商品"),

    PLATFORM(3, "平台券商品"),
    
    ADVERT(4, "广告券商品"),

    MAILA(5, "麦啦商品"),

    CARD_LIBRARY(6, "卡券库");


    private int gtype;

    private String desc;

    GoodsTypeEnum(int gtype, String desc) {
        this.gtype = gtype;
        this.desc = desc;
    }


    public int getGtype() {
        return gtype;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 根据类型，反查枚举类<br/>
     * 若是没找到，返回null
     *
     * @param type 枚举类型
     * @return 枚举类
     */
    public static GoodsTypeEnum getGoodsTypeEnum(int type) {

        GoodsTypeEnum[] values = GoodsTypeEnum.values();
        for (GoodsTypeEnum value : values) {
            if (value.getGtype() == type) {
                return value;
            }
        }

        return null;
    }
}
