package cn.com.duiba.goods.center.api.remoteservice.couponcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.couponcode.CouponCodeBatchDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteCouponCodeBatchService {
    public List<CouponCodeBatchDto> findAllByBaseId(Long baseId);

    public CouponCodeBatchDto findBatchByBatchNameAndEffectTime(Long baseId, Date beginEffectTime, Date endEffectTime);

    public int deleteBatchById(Long batchId);

    public Long insertBatch(CouponCodeBatchDto batch);

    public int findBatchCountByBaseId(Long baseId);

    public CouponCodeBatchDto findCouponCodeBatchByBatchId(Long batchID);

    public List<CouponCodeBatchDto> findListByBaseIdAndDate(Map<String, Object> maps);

}
