package cn.com.duiba.goods.center.api.remoteservice.tool.sku;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import org.javatuples.Pair;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc SKU解析器
 * @Author xuwei
 * @Date 2018/11/12
 */
public interface SkuResolver<T, R extends Serializable> {
    /**
     * 解析多节点SKU
     *
     * @param appItemId
     * @param itemId
     * @param nodes
     * @return
     */
    List<T> resolveNodes(Long appItemId, Long itemId, List<SkuAttributeNode<R>> nodes);

    /**
     * 解析多节点SKU
     *
     * @param appItemId
     * @param itemId
     * @param nodes
     * @param listener
     * @return
     */
    List<T> resolveNodes(Long appItemId, Long itemId, List<SkuAttributeNode<R>> nodes, ResolverListener<SkuAttributeNode<R>, T> listener);

    /**
     * 解析单节点SKU
     *
     * @param appItemId
     * @param itemId
     * @param node
     */
    List<T> resolveNode(Long appItemId, Long itemId, SkuAttributeNode<R> node);

    /**
     * 将sku解析成树型结构
     *
     * @param skuList
     * @return
     */
    List<SkuAttributeNode<R>> reverse(List<T> skuList);

    /**
     * 将sku解析成树型结构
     *
     * @param skuList
     * @param listener
     * @return
     */
    List<SkuAttributeNode<R>> reverse(List<T> skuList, ResolverListener<T, Pair<SkuAttributeNode<R>, String>> listener);

    /**
     * 解析监听器
     *
     * @param <I> 输入类型
     * @param <O> 输出类型
     */
    interface ResolverListener<I, O> {
        void apply(I input, O output);
    }
}
