package cn.com.duiba.goods.center.api.remoteservice.dto.model;

import cn.com.duiba.goods.center.api.remoteservice.enums.GoodsItemSourceType;

import java.io.Serializable;
import java.util.List;

/**
 * Created by xiaoxuda on 2018/8/3.
 */
public class GoodsItemSkuConfigDto implements Serializable {
    private static final long serialVersionUID = -7433048027547591117L;

    /**标准商品ID**/
    private Long goodsItemId;
    /**渠道类型**/
    private GoodsItemSourceType sourceType;
    /**具体商品ID**/
    private Long itemId;
    /**
     * sku配置
     */
    private List<SkuItem> skuItems;

    public static class SkuItem implements Serializable{
        private static final long serialVersionUID = 5775043338019466546L;
        /**id**/
        private Long id;

        /**规格配置，JSONArray结构，每一项的配置结构为：{spec1:val,spec2:val}**/
        private String specConf;

        /**价格，单位分**/
        private Integer price;

        /**划线价格**/
        private Integer priceShow;
        /**
         * 库存
         */
        private Integer stock;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getSpecConf() {
            return specConf;
        }

        public void setSpecConf(String specConf) {
            this.specConf = specConf;
        }

        public Integer getPrice() {
            return price;
        }

        public void setPrice(Integer price) {
            this.price = price;
        }

        public Integer getPriceShow() {
            return priceShow;
        }

        public void setPriceShow(Integer priceShow) {
            this.priceShow = priceShow;
        }

        public Integer getStock() {
            return stock;
        }

        public void setStock(Integer stock) {
            this.stock = stock;
        }
    }

    public Long getGoodsItemId() {
        return goodsItemId;
    }

    public void setGoodsItemId(Long goodsItemId) {
        this.goodsItemId = goodsItemId;
    }

    public GoodsItemSourceType getSourceType() {
        return sourceType;
    }

    public void setSourceType(GoodsItemSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public List<SkuItem> getSkuItems() {
        return skuItems;
    }

    public void setSkuItems(List<SkuItem> skuItems) {
        this.skuItems = skuItems;
    }


}
