package cn.com.duiba.goods.center.api.remoteservice.dto;

import java.io.Serializable;

public class TbGoodsOpenUrlDto implements Serializable {

	private static final long serialVersionUID = 817778386586796865L;

	/** 是否为IOS下载链接/打开应用 */
	public static final int SWITCH_IOS_SELECT_TYPE = 1;
	/** 下载链接/上传APK */
	public static final int SWITCH_AND_SELECT_TYPE = 2;
	/** 下载链接 是勾选 */
	public static final int SWITCH_DOWNLOAD_ALERT_TYPE = 3;
	/** 特定应用是否勾选 */
	public static final int SWITCH_GANJI_TYPE = 4;

	private Long id;
	// 来源ID
	private Long gid;
	// 安卓下载URL
	private String androidDownload;
	// IOS下载URL
	private String iosDownload;
	// 弹层中按钮往那条 0商家落地页 1兑换详情页
	private Integer immediatelyButton;
	// 来源类型 0:兑吧商品 1：自有商品 2：券库
	private Integer gtype;
	// 安卓 IOS 下载状态保存
	private Long switches;
	//新版跳转链接
	private String linkUrl;

	public Long getGid() {
		return gid;
	}

	public void setGid(Long gid) {
		this.gid = gid;
	}

	public String getAndroidDownload() {
		return androidDownload;
	}

	public void setAndroidDownload(String androidDownload) {
		this.androidDownload = androidDownload;
	}

	public String getIosDownload() {
		return iosDownload;
	}

	public void setIosDownload(String iosDownload) {
		this.iosDownload = iosDownload;
	}

	public Integer getImmediatelyButton() {
		return immediatelyButton;
	}

	public void setImmediatelyButton(Integer immediatelyButton) {
		this.immediatelyButton = immediatelyButton;
	}

	public Integer getGtype() {
		return gtype;
	}

	public void setGtype(Integer gtype) {
		this.gtype = gtype;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getSwitches() {
		return switches;
	}

	public void setSwitches(Long switches) {
		this.switches = switches;
	}

	public String getLinkUrl() {
		return linkUrl;
	}

	public void setLinkUrl(String linkUrl) {
		this.linkUrl = linkUrl;
	}

	public boolean isOpTypeAppItem(int opType) {
		long v = 1 << opType;
		long ret = switches & v;
		return ret != 0;
	}
}