package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;
import java.util.Date;

public class CouponBatchDto implements Serializable {
	private static final long serialVersionUID = 5321243L;
	public static final int ActiveNew = 0;// 新建批次
	public static final int ActiveUsing = 1;// 正在使用
	public static final int ActiveUsed = 2;// 已使用
	public static final int ActiveOverdue = 3;// 已过期
	public static final int ActiveDeleted = 4;// 删除

	private Long id;
	private Long itemId;
	private Long appItemId;

	private Date validStartDate;// 有效期开始时间
	private Date validEndDate; // 有效期结束时间
	private Integer remaining ;// 库存
	private Integer active ; // 批次状态

	private Date gmtCreate;
	private Date gmtModified;

	//不存于数据库，只用做显示的时间段
	private String timeQuantum;

	public CouponBatchDto() {
	}

	public CouponBatchDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public CouponBatchDto(boolean init4insert) {
		if (init4insert) {
			remaining = 0;
			active = ActiveNew;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getItemId() {
		return itemId;
	}
	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}
	public Long getAppItemId() {
		return appItemId;
	}
	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}
	public Date getValidStartDate() {
		return validStartDate;
	}
	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}
	public Date getValidEndDate() {
		return validEndDate;
	}
	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}
	public Integer getRemaining() {
		return remaining;
	}
	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}
	public Integer getActive() {
		return active;
	}
	public void setActive(Integer active) {
		this.active = active;
	}
	public Date getGmtCreate() {
		return gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getTimeQuantum() {
		return timeQuantum;
	}

	public void setTimeQuantum(String timeQuantum) {
		this.timeQuantum = timeQuantum;
	}
}
