package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import java.io.Serializable;

/**
 * 获取积分DTO
 */
public class CreditsDto implements Serializable {

	private static final long serialVersionUID = 4535128775184076362L;

	private ItemKeyDto itemKey;
	private String degree;
	private Long appCreditsRate;
	
	private Long credis;
	
	public CreditsDto(){
		
	}

	/**
	 * 构造方法
	 * 
	 * @param itemKeyDto
	 * @param degree
	 * @param appCreditsRate
	 */
	public CreditsDto(ItemKeyDto itemKeyDto, String degree, Long appCreditsRate) {
		this.itemKey = itemKeyDto;
		this.degree = degree;
		this.appCreditsRate = appCreditsRate;
	}

	/**
	 * 用来做比对
	 * 
	 * @return
	 */
	public String getUniqueKey() {
		Long appItemId = itemKey.getAppItem() == null ? 0 : itemKey.getAppItem().getId();
		Long itemId = itemKey.getItem() == null ? 0 : itemKey.getItem().getId();
		return appItemId + "_" + itemId;
	}

	public ItemKeyDto getItemKey() {
		return itemKey;
	}

	public void setItemKey(ItemKeyDto itemKey) {
		this.itemKey = itemKey;
	}

	public String getDegree() {
		return degree;
	}

	public void setDegree(String degree) {
		this.degree = degree;
	}

	public Long getAppCreditsRate() {
		return appCreditsRate;
	}

	public void setAppCreditsRate(Long appCreditsRate) {
		this.appCreditsRate = appCreditsRate;
	}

	public Long getCredis() {
		return credis;
	}

	public void setCredis(Long credis) {
		this.credis = credis;
	}
	
}
