package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by sunyan on 2019/1/18.
 */
public enum AppItemLockTypeEnum {
    PRICE(1, "价格锁"),
    SKU(2, "规格锁");


    private int type;

    private String desc;

    AppItemLockTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }


    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 根据类型，反查枚举类<br/>
     * 若是没找到，返回null
     *
     * @param type 枚举类型
     * @return 枚举类
     */
    public static AppItemLockTypeEnum getAppItemLockTypeEnum(int type) {

        AppItemLockTypeEnum[] values = AppItemLockTypeEnum.values();
        for (AppItemLockTypeEnum value : values) {
            if (value.getType() == type) {
                return value;
            }
        }
        return null;
    }
}
