package cn.com.duiba.goods.center.api.remoteservice.banner;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.banner.PlatformBannerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 前台手机端查询 banner 接口
 */
@AdvancedFeignClient
public interface RemotePlatformBannerService {
 
    /**
     * 业务方调用,此处会把所有对应业务的可用 banner 取出,然后进行标签过滤,返回给业务方
     * 业务方需要再调用活动中心,进行活动状态的过滤
     * @param appId
     * @param bizCode
     * @return
     */
    DubboResult<List<PlatformBannerDto>> findPlatformBanners(Long appId, int bizCode);
 
}
