package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.api.enums.GoodsTypeEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xiaoxuda on 2016/11/17. 
 * 商品地域限制服务
 */
@AdvancedFeignClient
public interface RemoteAddrLimitService {

	/**
	 * 返回参数中能通过地域限制的商品项，ip为空且商品的地域限制开关打开时商品不可用
	 * 
	 * @param items
	 * @param ip
	 * @return
	 */
	public DubboResult<List<ItemKeyDto>> getItemCanPassAddrLimit(List<ItemKeyDto> items, String ip);

	/**
	 * IP地址兑换限制验证
	 * 
	 * @return
	 */
	public DubboResult<Boolean> ipValidation(ItemKeyDto itemKeyDto, String ip);

	/**
	 * 兑吧实物商品地域限制校验
	 * @param itemDto
	 * @param addrCode 传全的9位或者6位
	 * @return true 校验通过  false校验失败
	 */
	public Boolean verifyDuibaAddressLimit(ItemDto itemDto, String addrCode);

	/**
	 * 返回参数中能通过地域限制的商品项，经纬度为空且商品的地域限制开关打开时商品不可用
	 *
	 * @param items
	 * @return
	 */
	List<ItemKeyDto> getItemCanPassAddrLimitByPoint(List<ItemKeyDto> items, double latitude, double longitude);

	/**
	 * 查询商品地域限制
	 * @param gtype
	 * @param gid
	 * @return
	 */
	@Deprecated
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGid(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, Long gid);

	/**
	 * 查询商品地域限制
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGidApi(GoodsTypeEnum gtype, Long gid);

	/**
	 * 批量查询商品地域限制
	 * @param gtype
	 * @param gid
	 * @return
	 */
	@Deprecated
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGids(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype,List<Long>  gid);

	/**
	 * 批量查询商品地域限制
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGidsApi(GoodsTypeEnum gtype,List<Long>  gid);

	/**
	 * 查询type
	 * @param gtype
     * @param gid
	 * @return
	 */
	@Deprecated
	public DubboResult<Integer> findTypeByGid(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, Long gid);

	/**
	 * 查询type
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<Integer> findTypeByGidApi(GoodsTypeEnum gtype, Long gid);

	/**
	 * 批量添加
	 * @param addrLimitList
	 * @return 添加条数
	 */
	public DubboResult<Integer> batchInsertAddrLimit(List<AddrLimitDto> addrLimitList);

	/**
	 * 删除商品地域限制
	 * @param itemId
	 * @param appItemId
	 * @return 删除条数
	 */
	public DubboResult<Integer> deleteAddrLimit(Long itemId, Long appItemId);


	/**
	 * 根据 itemIds 查询地址限制
	 * @return
	 */
	List<AddrLimitDto> findByItemIdsOrItemIds(List<Long> itemIds,List<Long> appItemIds);


	/**
	 * 过滤 商品
	 * @param addrLimitList
	 * @param itemKeyDtos
	 * @param ip
	 * @return
	 */
	List<ItemKeyDto> filterCanPassAddrLimit(List<AddrLimitDto> addrLimitList,List<ItemKeyDto> itemKeyDtos,String ip) throws BizException;

	/**
	 * 过滤 商品
	 * @param addrLimitList
	 * @param itemKeyDtos
	 * @return
	 */
	List<ItemKeyDto> filterCanPassAddrLimitByPoint(List<AddrLimitDto> addrLimitList,List<ItemKeyDto> itemKeyDtos, double latitude, double longitude) throws BizException;
}
