package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 手机端标记枚举
 */
public enum ItemMarkEnum {

    MARK_NORMAL(0, "普通"),
    MARK_TIME(1, "秒杀"),
    MARK_QUANTITY(2, "限量"),
    MARK_LOTTERY(3, "抽奖"),
    MARK_ACTIVITY(4, "活动(专题)"),
    MARK_NEW(5, "NEW(新商品)"),
    MARK_ADDRLIMIT(6, "地域限制"),
    MARK_GAME(7, "游戏"),
    MARK_QUESTION(8, "答题"),
    MARK_QUIZZ(9, "测试题"),
    MARK_NGAME(7, "游戏"),
    MARK_GUESS(10, "竞猜");

    private int    value;
    private String desc;

    ItemMarkEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * value
     * @return
     */
    public int value() {
        return this.value;
    }

    /**
     * desc
     * @return
     */
    public String desc() {
        return this.desc;
    }

    /**
     * fromValue
     * @param value
     * @return
     */
    public static ItemMarkEnum fromValue(int value) {
        for (ItemMarkEnum it : ItemMarkEnum.values()) {
            if (value == it.value()) {
                return it;
            }
        }
        return null;
    }

}
