package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * banner类型枚举
 */
public enum BannerTypeEnum {

    ACTIVITY(1, "兑吧活动"),
    URL(2, "URL");

    private int    value;
    private String desc;

    BannerTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static BannerTypeEnum fromValue(int value) {
        for (BannerTypeEnum it : BannerTypeEnum.values()) {
            if (value == it.value()) {
                return it;
            }
        }
        return null;
    }
}
