package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.api.bo.KeyValueDto;
import cn.com.duiba.api.bo.KeyValueEntity;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemNewExtraDto;

import java.util.List;

/**
 *
 * 商品新拓展信息接口
 * 增加app item的接口请加appItem
 * Created by hww on 2018/4/25 下午8:20.
 */
@AdvancedFeignClient
public interface RemoteItemNewExtraService {

    /**
     * 单独find item extra,注意不是app item extra
     * @param itemId
     * @return
     */
    ItemNewExtraDto findItemNewExtra(Long itemId);

    /**
     * 批量insert Item extra
     * @param itemId
     * @return
     */
    int updateOrInsertBatchApi(Long itemId, List<KeyValueDto> kvs);

    /**
     * 批量insert appitem extra
     *
     * @param appItemId
     * @return
     */
    int updateOrInsertBatchAppItemExtra(Long appItemId, List<KeyValueDto> kvs);

    int updateOrInsertAppItemExtraApi(Long appItemId, KeyValueDto kvs);

    /**
     * 单独insert Item extra
     * @param itemId
     * @return
     */
    int updateOrInsertOne(Long itemId, String propName, String propValue);

    /**
     * 单独删除Item extra
     * @param itemId
     * @return
     */
    int deleteOneValue(Long itemId, String propName);

    /**
     * 删除Item extra
     * @param itemId
     * @return
     */
    boolean deleteByItemId(Long itemId);

    /**
     * 批量insert appItem请使用insertAppItemBatch
     * @param appItemId
     * @param kvs
     * @return
     */
    @Deprecated
    int insertBatchApi(Long appItemId, List<KeyValueDto> kvs);

    /**
     * 批量insert appItem
     * @param appItemId
     * @param kvs
     * @return
     */
    int insertAppItemBatchApi(Long appItemId, List<KeyValueDto> kvs);

    /**
     * 单独insert appItem
     * @param appItemId
     * @param kvs
     * @return
     */
    int updateAppItemApi(Long appItemId, KeyValueDto kvs);


    List<KeyValueEntity> findAppItemNewExtraApi(Long appItemId,Long limitNum);

    List<KeyValueEntity> findAppItemAllApi(Long appItemId);

    int updateEntriesApi(Long appItemId,List<KeyValueDto> kv);

    List<KeyValueEntity> findAppItemEntriesByItemAndPropApi(List<Long> appItemIdList, String propName, String propValue);

    List<KeyValueEntity> findAppItemEntriesByItemAndPropNameApi(List<Long> appItemIdList, String propName);

    /**
     * 根据prop_name寻找app_item_id集合
     * @param propName
     * @return
     */
    List<KeyValueEntity> findAppItemIdsByPropNameApi(String propName);


    List<KeyValueDto> findItemAllApi(Long itemId);

    /**
     * 根据app_item_id 和 prop_name 逻辑删除数据
     *
     * @param appItemId 自有商品id
     * @param propNames keys
     * @return
     */
    int deleteByAppItemIdAndPropNames(Long appItemId, List<String> propNames);

    /**
     * 根据app_item_id 和 prop_name 查询数据
     *
     * @param appItemId 自有商品id
     * @param propNames keys
     * @return
     */
    List<KeyValueDto> findValuesByAppItemIdAndPropNames(Long appItemId, List<String> propNames);

    /**
     * 虚拟商品同步拓展信息
     *
     * @param itemId 项id
     */
    void paceItemNewExtraForAppItemExtra(Long itemId);
}
