package cn.com.duiba.goods.center.api.remoteservice.dto.jbp;

import java.io.Serializable;

/**
 * 库存变更结果DTO
 * 
 * @author zhangdaqing
 * @Description 库存变更操作的结果，包含库存值和版本号
 */
public class StockChangeResultDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 新的库存值
     */
    private Long stock;

    /**
     * 新的版本号
     */
    private Long version;

    /**
     * 错误信息
     */
    private String errorMessage;

    public StockChangeResultDto() {
    }

    public StockChangeResultDto(boolean success, Long stock, Long version) {
        this.success = success;
        this.stock = stock;
        this.version = version;
    }

    public StockChangeResultDto(boolean success, String errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

