package cn.com.duiba.goods.center.api.remoteservice.jbp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.jbp.CStockDecrementResultDto;

import java.util.List;

/**
 * JBP供应商远程服务接口
 * 
 * @author zhangdaqing
 * @Description JBP供应商服务接口
 * @date 2025/11/17 11:17
 */
@AdvancedFeignClient
public interface RemoteJbpSupplierService {


    /**
     * 设置商品编码
     * 
     * @param jbpStockRecordId
     * @param productCode 商品编码
     * @param seconds 过期时间（秒），如果小于等于0则不过期
     * @return 是否设置成功
     */
    boolean setProductCode(Long jbpStockRecordId, String productCode, int seconds);

    /**
     * 查询商品编码
     * 
     * @param jbpStockRecordId
     * @return 商品编码，如果不存在或异常则返回null
     */
    String getProductCode(Long jbpStockRecordId);



    /**
     * 获取库存和版本号
     * 
     * @param itemId 商品ID
     * @param jbpStockRecordId JBP库存记录ID
     * @return 库存变更结果，包含库存值和版本号
     */
    String getStockAndVersion(
            Long itemId, Long jbpStockRecordId);

    /**
     * B端增量更新库存（非覆盖）
     * 使用独立的stock_key和version_key，通过增量更新避免覆盖C端扣减
     * 
     * @param itemId 商品ID
     * @param jbpStockRecordId JBP库存记录ID
     * @param delta 变更数量（正数补货，负数出库）
     * @return 变更后的库存数量，如果失败则返回null
     */
    Long bIncrementStock(Long itemId, Long jbpStockRecordId, Integer delta);

    /**
     * C端扣库存（从多个库存key中选择一个扣减）
     * 存在多个库存key，需要从其中一个扣减，并返回扣除的是哪个库存的key
     * C端扣除库存时需要校验版本号
     * 
     * @param itemId 商品ID
     * @param jbpStockRecordIds 多个JBP库存记录ID列表
     * @param decrementAmount 扣减数量（正数）
     * @param expectedVersion 期望的版本号
     * @return C端扣库存结果，包含是否成功、扣减的库存key、新的库存值和版本号
     */
    CStockDecrementResultDto cDecrementStock(
            Long itemId, List<Long> jbpStockRecordIds, Integer decrementAmount, Long expectedVersion);
}
