package cn.com.duiba.intersection.serivce.api.remoteservice;

import cn.com.duiba.intersection.serivce.api.remoteservice.dto.KVDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Set;

/**
 * Created by zzy on 2017/1/22.
 */
public interface RemoteKVService {

    /**
     * 批量查询.
     *
     * @param space      使用KVSpaceEnum定义的常量，未定义的space会抛出异常
     * @param consumerId 用户ID
     * @param keys       查询的key集合
     * @return 结果
     * @throws IllegalArgumentException
     */
    DubboResult<List<KVDto>> gets(String space, Long consumerId, Set<String> keys);

    /**
     * 增加一个记录.
     *
     * @param kvDto 参数,其中，stringValue和intValue二者必须有一个非空(null)
     * @return true 成功，false 失败
     * @throws IllegalArgumentException
     */
    DubboResult<Boolean> set(KVDto kvDto);

    /**
     * 查询单个值.
     *
     * @param space      使用KVSpaceEnum定义的常量，未被定义的space会抛出异常
     * @param consumerId 用户ID
     * @param key        key
     * @return 结果
     * @throws IllegalArgumentException
     */
    DubboResult<KVDto> get(String space, Long consumerId, String key);

    /**
     * 整数值自增.
     *
     * @param space      使用KVSpaceEnum定义的常量，未被定义的space会抛出异常
     * @param consumerId 用户ID
     * @param key        key
     * @return true 成功，false 失败
     * @throws IllegalArgumentException
     */
    DubboResult<Boolean> incrIntValue(String space, Long consumerId, String key);

    /**
     * 整数值自减.
     *
     * @param space      使用KVSpaceEnum定义的常量，未被定义的space会抛出异常
     * @param consumerId 用户ID
     * @param key        key
     * @return true 成功，false 失败
     * @throws IllegalArgumentException
     */
    DubboResult<Boolean> decrIntValue(String space, Long consumerId, String key);

    /**
     * 删除记录.
     *
     * @param space      使用KVSpaceEnum定义的常量，未被定义的space会抛出异常
     * @param consumerId 用户ID
     * @param key        key
     * @return true 成功，false 失败
     * @throws IllegalArgumentException
     */
    DubboResult<Boolean> remove(String space, Long consumerId, String key);

}
