package cn.com.duiba.intersection.serivce.api.remoteservice;

import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerEditDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerPageDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.PlatformBannerSaveDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.BizCodeEnum;
import cn.com.duiba.intersection.serivce.api.remoteservice.tools.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 提供给管理员后台操作接口
 */
public interface RemotePlatformBannerBackendService {

    /**
     * 管理员后台,banner 分页查询
     * @param offset
     * @param max
     * @param bizCode
     * @return
     */
    DubboResult<Page<PlatformBannerPageDto>> findPlatformBannersPage(int current, int pageSize, BizCodeEnum bizCode);

    /**
     * 管理员后台,banner 启用
     * @param bannerId
     * @return
     */
    DubboResult<Boolean> enable(Long bannerId);

    /**
     * 管理员后台,banner 禁用
     * @param bannerId
     * @return
     */
    DubboResult<Boolean> disable(Long bannerId);

    /**
     * 管理员后台,banner 删除
     * @param bannerId
     * @return
     */
    DubboResult<Boolean> delete(Long bannerId);

    /**
     * 管理员后台,banner 编辑
     * @param bannerId
     * @return
     */
    DubboResult<PlatformBannerEditDto> findPlatformBanner4Edit(Long bannerId);

    /**
     * 管理员后台,banner 创建/保存
     * @param pbSaveDto
     * @param bizCode
     * @return
     */
    DubboResult<Boolean> save(PlatformBannerSaveDto pbSaveDto, BizCodeEnum bizCode);
}
