package cn.com.duiba.kjy.base.api.request;

/**
 * http 返回体构建工具类
 * @author dugq
 * @date 2021/11/8 2:10 下午
 */
public final class ResultBuilders {

    private ResultBuilders() {
        // X Y
    }

    /**
     * 带自定义响应码的描述信息数据对象Result
     *
     * @param code 错误码
     * @param desc 失败描述
     * @return Result
     */
    public static <T> Result<T> fail(String code, String desc) {
        Result<T> result = new Result<>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    /**
     * 使用默认错误码,描述错误信息(统一使用默认错误码)
     *
     * @param desc 失败描述
     * @return Result
     */
    public static <T> Result<T> fail(String desc) {
        return fail(ErrorCodeInterface.DEFAULT_FAIL_CODE, desc);
    }

    /**
     * 使用默认错误码,描述错误信息(统一使用默认错误码)
     *
     * @param errCode
     * @return Result
     */
    public static <T> Result<T> fail(ErrorCodeInterface errCode) {
        return fail(errCode.getCode(), errCode.getDesc());
    }

    /**
     * 使用错误码,描述错误信息
     *
     * @param errCode
     * @return Result
     */
    public static <T> Result<T> fail(ErrorCodeInterface errCode, T data) {
        Result<T> result = new Result<>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(errCode.getCode());
        result.setDesc(errCode.getDesc());
        result.setData(data);
        return result;
    }

    /**
     * 带有数据的失败返回,统一使用默认错误码
     *
     * @param desc 失败信息
     * @param data 数据
     * @return Result
     */
    public static <T> Result<T> fail(String desc, T data) {
        return fail(ErrorCodeInterface.DEFAULT_FAIL_CODE, desc, data);
    }

    /**
     * 带有数据的失败返回
     *
     * @param code 失败码
     * @param desc 失败信息
     * @param data 数据
     * @return Result
     */
    public static <T> Result<T> fail(String code, String desc, T data) {
        Result<T> result = new Result<>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        result.setData(data);
        return result;
    }

    /**
     * 使用自定义成功码的成功数据对象构建
     *
     * @param code 成功码
     * @param data 数据
     * @return Result
     */
    public static <T> Result<T> success(String code, T data) {
        Result<T> result = new Result<>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setDesc("OK");
        return result;
    }


    /**
     * 统一使用默认成功码的成功数据对象构建
     *
     * @param data 数据
     * @return Result
     */
    public static <T> Result<T> success(T data) {
        return success(ErrorCodeInterface.DEFAULT_SUCCESS_CODE, data);
    }


    /**
     * 成功,不返回任何数据,统一使用默认成功码
     *
     * @return
     */
    public static <T> Result<T> success() {
        return success(ErrorCodeInterface.DEFAULT_SUCCESS_CODE, null);
    }
}
