/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.service.datasource;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DbMovingDataSource
extends AbstractRoutingDataSource {
    private final DataSource oldDataSource;
    private final DataSource newDataSource;
    private final String redisKey;
    private static final String OLD_KEY = "old";
    private static final String NEW_KEY = "new";
    private final Function<String, String> getFlagFunction;

    public DbMovingDataSource(DataSource oldDataSource, DataSource newDataSource, String redisKey, Function<String, String> getFlagFunction) {
        this.oldDataSource = oldDataSource;
        this.newDataSource = newDataSource;
        this.redisKey = redisKey;
        this.getFlagFunction = getFlagFunction;
    }

    public void afterPropertiesSet() {
        HashMap<String, DataSource> targetDataSource = new HashMap<String, DataSource>();
        targetDataSource.put(OLD_KEY, this.oldDataSource);
        targetDataSource.put(NEW_KEY, this.newDataSource);
        this.setTargetDataSources(targetDataSource);
        this.setDefaultTargetDataSource(this.oldDataSource);
        super.afterPropertiesSet();
    }

    protected Object determineCurrentLookupKey() {
        try {
            String flag = this.getFlag();
            if (Objects.nonNull(flag) && StringUtils.equals((String)flag, (String)"1")) {
                return NEW_KEY;
            }
            return OLD_KEY;
        }
        catch (Exception e) {
            this.logger.error((Object)"get key from redis has error!", (Throwable)e);
            return OLD_KEY;
        }
    }

    public String getFlag() {
        return this.getFlagFunction.apply(this.redisKey);
    }
}

