package cn.com.duiba.kjy.base.api.utils.autotest;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.api.enums.DeletedEnum;
import cn.com.duiba.user.service.api.dto.user.TestUserDto;
import cn.com.duiba.user.service.api.dto.user.UserExtDto;
import cn.com.duiba.user.service.api.remoteservice.user.RemoteTestUserService;
import cn.com.duiba.user.service.api.remoteservice.user.RemoteUserExtApiService;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 自动化测试工具类
 * @author zhanghuifeng
 * @date 2021/11/15 17:03
 */
public class AutoTestUtil {

    @Resource
    private RemoteTestUserService remoteTestUserService;
    @Resource
    private RemoteUserExtApiService remoteUserExtApiService;

    /**
     * 判断是否是自动化测试用户
     * @param userId  用户ID
     * @return true：是自动化测试用户
     */
    public boolean isAutoTestUser(Long userId){
        // 只有测试环境才存在自动化测试用户
        if (Objects.isNull(userId) || !SpringEnvironmentUtils.isTestEnv()){
            return false;
        }
        TestUserDto testUserDto = remoteTestUserService.findByUserId(userId);
        return Objects.nonNull(testUserDto) && Objects.equals(DeletedEnum.NON_DELETED.getCode(), testUserDto.getDeleted());
    }

    /**
     * 判断是否是自动化测试用户
     * @param openId  openId
     * @return true：是自动化测试用户
     */
    public boolean isAutoTestUser(String openId){
        // 只有测试环境才存在自动化测试用户
        if (StringUtils.isBlank(openId) || !SpringEnvironmentUtils.isTestEnv()){
            return false;
        }
        UserExtDto extDto = remoteUserExtApiService.findByOpenId(openId);
        if (Objects.isNull(extDto)){
            return false;
        }
        TestUserDto testUserDto = remoteTestUserService.findByUserId(extDto.getUserId());
        return Objects.nonNull(testUserDto) && Objects.equals(DeletedEnum.NON_DELETED.getCode(), testUserDto.getDeleted());
    }
}
