/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.request.iddecode;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.exception.KjjBaseException;
import cn.com.duiba.kjy.base.exception.errorcode.BaseErrorCode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class IdDecodeBean {
    private static final Logger log = LoggerFactory.getLogger(IdDecodeBean.class);

    protected Long decodeId(String value, Class<?> parameterType, String filedName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Long id = IdMakeUtil.decodingId(value);
        if (Objects.isNull(id) && (StringUtils.isNotBlank((CharSequence)value) || parameterType.isPrimitive())) {
            HttpServletRequest request = this.getRequest();
            log.warn("id ILLEGAL; url = {} \n Referer = {} \n X-Transaction-ID = {} \n \u975e\u6cd5\u53c2\u6570\uff1a {} = {} \n ", new Object[]{request.getRequestURI(), request.getHeader("Referer"), request.getHeader("X-Transaction-ID"), filedName, value});
            throw new KjjBaseException(BaseErrorCode.ID_ERROR);
        }
        if (Objects.nonNull(id) && StringUtils.equals((CharSequence)value, (CharSequence)id.toString())) {
            try {
                HttpServletRequest request = this.getRequest();
                log.info("id maker has not use encoding; url = {} \n Referer = {} \n hash-path = {}  \n {} = {}  \n \n please deal this url quickly!", new Object[]{request.getRequestURI(), request.getHeader("Referer"), request.getHeader("W-Hash-Path"), filedName, value});
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
            }
        }
        return id;
    }

    private HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    protected boolean isPrimitiveOrString(Class<?> parameterType) {
        return parameterType.isPrimitive() || Number.class.isAssignableFrom(parameterType) || parameterType.equals(String.class);
    }

    protected Boolean isArray(Class<?> parameterType) {
        return parameterType.isArray();
    }

    protected Boolean isCollection(Class<?> parameterType) {
        return List.class.isAssignableFrom(parameterType) || Set.class.isAssignableFrom(parameterType);
    }

    protected List<Field> getAllFields(Class clazz) {
        if (Objects.isNull(clazz) || clazz.isInterface()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != Object.class) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    protected Boolean isMap(Class<?> parameterType) {
        return Map.class.isAssignableFrom(parameterType);
    }
}

