/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler;

import cn.com.duiba.kjy.base.customweb.exception.ResponseNotClosedException;
import cn.com.duiba.kjy.base.customweb.exception.ResponseStatusException;
import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.factory.FilterChainFactory;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.HandlerExecutionChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DispatcherHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private final List<RequestMappingsRegister> requestMappingsRegisterList;
    private final List<KjjInterceptor> interceptorList;
    @Resource
    private FilterChainFactory filterChainFactory;

    public DispatcherHandler(List<RequestMappingsRegister> requestMappingsRegisterList, List<KjjInterceptor> interceptors) {
        this.requestMappingsRegisterList = requestMappingsRegisterList;
        this.interceptorList = interceptors;
    }

    public void handler(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        httpRequest.setResponse(response);
        CustomFilterChain customFilterChain = this.filterChainFactory.getInstance(this);
        customFilterChain.filter(httpRequest, response);
    }

    public void service(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        StopWatch handle = StopWatchUtil.getAndStart();
        HandlerExecutionChain mappedHandler = this.getRequestMapping(httpRequest);
        if (Objects.isNull(mappedHandler)) {
            throw new ResponseStatusException(HttpResponseStatus.NOT_FOUND);
        }
        StopWatchUtil.mark(StopWatchUtil.Key.EXT1, httpRequest, handle);
        try {
            RequestHandlerMappingAdaptor adaptor = mappedHandler.getAdaptor();
            boolean stop = mappedHandler.applyPreHandle(httpRequest, response, mappedHandler.getHandler());
            if (stop) {
                if (!response.isClosed()) {
                    log.error("response is not closed in interceptor.uri = {}", (Object)httpRequest.uri());
                    throw new ResponseNotClosedException();
                }
                return;
            }
            StopWatchUtil.mark(StopWatchUtil.Key.EXT2, httpRequest, handle);
            StopWatch ctrl = StopWatchUtil.getAndStart();
            Object result = adaptor.handler(mappedHandler.getHandler(), httpRequest, response);
            StopWatchUtil.stop(StopWatchUtil.Key.CTRL, httpRequest, ctrl);
            StopWatchUtil.mark(StopWatchUtil.Key.EXT3, httpRequest, handle);
            mappedHandler.applyPostHandle(httpRequest, response, mappedHandler.getHandler(), result);
            StopWatchUtil.mark(StopWatchUtil.Key.EXT4, httpRequest, handle);
            adaptor.handlerResult(result, httpRequest, response, mappedHandler.getHandler());
            StopWatchUtil.mark(StopWatchUtil.Key.EXT5, httpRequest, handle);
            try {
                mappedHandler.afterCompletion(httpRequest, response, null);
            }
            catch (Exception e) {
                log.error("interceptor after completion has exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            mappedHandler.afterCompletion(httpRequest, response, e);
            throw e;
        }
        finally {
            StopWatchUtil.stop(StopWatchUtil.Key.HANDLE, httpRequest, handle);
        }
    }

    public HandlerExecutionChain getRequestMapping(KjjHttpRequest httpRequest) {
        for (RequestMappingsRegister requestMappingsRegister : this.requestMappingsRegisterList) {
            Object handler = requestMappingsRegister.getHandler(httpRequest);
            if (!Objects.nonNull(handler)) continue;
            return new HandlerExecutionChain(this.interceptorList, requestMappingsRegister, handler);
        }
        return null;
    }
}

