package cn.com.duiba.kjy.base.customweb.util;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import lombok.Data;
import org.springframework.util.StopWatch;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author dugq
 * @date 2021/5/25 10:37 上午
 */
public class StopWatchUtil {

    public static Function<KjjHttpRequest,Boolean> filter = (KjjHttpRequest request)-> false;

    public static StopWatch getAndStart(){
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public static void stop(Key key,KjjHttpRequest request, StopWatch stopWatch){
       try {
           stopWatch.stop();
           if (StopWatchUtil.filter.apply(request)){
               key.count.incrementAndGet();
               key.time.addAndGet(stopWatch.getLastTaskTimeNanos());
           }
       }catch (Exception e){

       }
    }

    public static void mark(Key key,KjjHttpRequest request, StopWatch stopWatch){
        if (StopWatchUtil.filter.apply(request)){
            stopWatch.stop();
            key.count.incrementAndGet();
            key.time.addAndGet(stopWatch.getTotalTimeNanos());
            stopWatch.start();
        }
    }

    public enum Key{
        TOTAL,FILTER,HANDLE,INTERCEPTOR_BEFORE,ARGS,INTERCEPTOR_AFTER,CTRL,EXT1,EXT2,EXT3,EXT4,EXT5,EXT6,EXT7,EXT8,EXT9,EXT10
        ;
        public AtomicInteger count;
        public AtomicLong time;
        Key() {
           count = new AtomicInteger();
           time = new AtomicLong();
        }
    }

    @Data
    public static class Detail{
        private String name;
        private int count;
        private long time;
        private long avg;
    }

   public static List<Detail> getAndClear(){
       return Stream.of(Key.values()).map(key->{
           Detail detail = new Detail();
           detail.count = key.count.getAndSet(0);
           detail.name = key.name();
           detail.time = key.time.getAndSet(0);
           if (detail.count>0){
               detail.avg = detail.time / detail.count;
           }else{
               return null;
           }
           return detail;
       }).filter(Objects::nonNull).collect(Collectors.toList());
   }
}
