/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.sever.KjjChannelInboundHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(ServerChannelInitializer.class);
    private DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;

    public ServerChannelInitializer(DispatcherHandler dispatcherHandler, ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.exceptionChain = exceptionChain;
    }

    protected void initChannel(SocketChannel ch) {
        this.initHandler(ch.pipeline());
    }

    protected void initHandler(ChannelPipeline channelPipeline) {
        this.intProtocolHandler(channelPipeline);
        channelPipeline.addLast(new ChannelHandler[]{new IdleStateHandler(15, 0, 0)});
    }

    private void intProtocolHandler(ChannelPipeline channelPipeline) {
        channelPipeline.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
        channelPipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        channelPipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
        channelPipeline.addLast(new ChannelHandler[]{new KjjChannelInboundHandler(this.dispatcherHandler, this.exceptionChain)});
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
    }
}

