package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.bean.login.LoginBean;
import cn.com.duiba.kjy.base.api.bean.login.LoginConstant;
import cn.com.duiba.kjy.base.exception.KjjBaseException;
import cn.com.duiba.kjy.base.exception.errorcode.BaseErrorCode;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author dugq
 * @date 2020/12/28 8:49 下午
 */
public class TokenUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String encodeToken(LoginBean loginBean) {
        if (Objects.isNull(loginBean)){
            return null;
        }
        loginBean.setDisableTime(DateUtils.addDays(new Date(),LoginConstant.LOGIN_CKE_MP_EXPIRY_DAYS).getTime());
        loginBean.setTime(loginBean.getDisableTime());
        try {
            return BlowfishUtils.encryptBlowfish(objectMapper.writeValueAsString(loginBean), LoginConstant.KEY_ENCRYPT);
        } catch (JsonProcessingException e) {
            throw new KjjBaseException(BaseErrorCode.JACKSON_SERIALIZABLE);
        }
    }


    public static <T extends LoginBean>  T decodeToken(String value ,Class<T> clazz) {
        if (StringUtils.isBlank(value)){
            return null;
        }
        try {
            final String decodeStr = BlowfishUtils.decryptBlowfish(value, LoginConstant.KEY_ENCRYPT);
            return objectMapper.readValue(decodeStr,clazz);
        }catch (Exception e){
            return null;
        }
    }

}
