package cn.com.duibaboot.kjj.oss.template.util;

import com.aliyun.oss.model.GenericResult;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author dugq
 * @date 2021/7/27 10:22 上午
 */
public class OssUtils {
    private OssUtils(){}

    public static  <T extends GenericResult> boolean successful(T result){
        return Objects.isNull(result.getResponse()) || result.getResponse().isSuccessful();
    }

    public static  <T extends GenericResult> String getErrorMessage(T result){
        if (Objects.isNull(result.getResponse())){
            return null;
        }
        return result.getResponse().getErrorResponseAsString();
    }

    public static void validatorObjectName(String objectName){
        if (StringUtils.isBlank(objectName)){
            throw new UnsupportedOperationException("object name 作为对象的key不可以为空");
        }
        if (objectName.startsWith("/") || objectName.startsWith("\\")){
            throw new UnsupportedOperationException("object name 作为对象的key不能以/或者\\开头。path会自动拼接。不需要额外添加");
        }
    }
}
