package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.exception.ArgResolverException;
import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/25 3:23 下午
 *
 */
@Order(-10)
public class PrimitiveParamResolver implements ArgsResolver {
    @Resource
    private ConversionService conversionService;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        final ResponseBody annotation = parameter.getAnnotation(ResponseBody.class);
        if (Objects.nonNull(annotation)){
            return false;
        }
        final RequestHeader  requestHeader = parameter.getAnnotation(RequestHeader.class);
        if (Objects.nonNull(requestHeader)){
            return false;
        }
        return ParamReflectUtil.isPrimitive(parameter.getType());
    }

    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) {
        String value = httpRequest.getParamMap().getFirst(parameterBean.getName());
        if (StringUtils.isBlank(value)){
            value = parameterBean.getDefaultValue();
        }
        if (Objects.isNull(value)){
            return null;
        }
        /**
         * spring 的实现，{@link org.springframework.web.method.annotation.RequestParamMethodArgumentResolver}
         * spring 的实现中利用webDataBind来额外也实现了参数验证，我们当下暂未实现。
         *
         */
        final boolean canConvert = conversionService.canConvert(value.getClass(), parameterBean.getType());
        if (canConvert){
            final TypeDescriptor nested = TypeDescriptor.nested(parameterBean.getMethodParameter(), 0);
            if (Objects.nonNull(nested)){
                return conversionService.convert(value,TypeDescriptor.forObject(value), nested);
            }
        }
        throw new ArgResolverException("can not convert parameter : url = "+httpRequest.uri()+"parameter = "+parameterBean.getName());
    }
}
