package cn.com.duiba.kjy.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.enums.seller.SellerImportTaskStatusEnum;

/**
 * 销售员导入任务服务类
 * @author lizhi
 * @date 2019-06-04
 */
@AdvancedFeignClient
public interface RemoteSellerImportTaskService {

    /**
     * 根据URL获取内容ID
     * @param url URL链接
     * @return 内容ID
     */
    Long getContentIdByUrl(String url);

    /**
     * 更新任务解析结果
     * @param taskId 任务ID
     * @param state 任务状态
     * @see SellerImportTaskStatusEnum
     * @param contentId 内容ID
     * @param message 错误信息
     * @return 0-失败
     */
    int updateTaskAnalyzeResult(Long taskId, Integer state, Long contentId, String message);

    void taskAnalyzeSuccess(Long taskId, Long contentId);
}
