package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.UserDto;
import cn.com.duiba.kjy.api.params.UserSearchParam;

import java.util.Date;
import java.util.List;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 保存用户
     * @param dto
     * @return
     */
    Long save(UserDto dto);

    /**
     * 保存用户扩展信息
     * @param dto
     * @return
     */
    Boolean saveUserExt(UserDto dto);

    /**
     * 保存用户手机号
     * @param dto
     * @return
     */
    Boolean updatePhoneNumber(UserDto dto);

    /**
     * 更新用户是否关注公众号
     * @param dto
     * @return
     */
    Boolean updateUserSubscribe(UserDto dto);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @param extType 类型
     * @return
     */
    UserDto findById(Long userId, String extType);

    /**
     * 通过id列表批量查询用户
     * @param ids
     * @return
     */
    List<UserDto> findByIds(List<Long> ids);

    /**
     * 根据unionId查询
     * @param unionId
     * @param extType 类型
     * @return
     */
    UserDto findByUnionId(String unionId, String extType);

    /**
     * 根据openId查询
     * @param openId
     * @return
     */
    UserDto findByOpenId(String openId);

    /**
     * 根据sellerId查询
     * @param sellerId
     * @return
     */
    UserDto findBySellerId(Long sellerId, String extType);

    /**
     * 查询用户扩展信息
     * @param openid
     * @return
     */
    UserDto findExtByOpenid(String openid);

    /**
     * 查询用户扩展信息
     * @param userId
     * @param extType
     * @return
     */
    UserDto findExtByUserAndType(Long userId, String extType);

    int modifyLastPushEventTime(String openId, Date date);

    List<UserDto> findByParam(UserSearchParam userParam);

    Boolean updateAvatar(Long userId, String avatar);
}
