package cn.com.duiba.kjy.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerImportTaskDto;
import cn.com.duiba.kjy.api.enums.seller.SellerImportTaskStatusEnum;

/**
 * 销售员导入服务类
 * @author lizhi
 * @date 2019-06-04
 */
@AdvancedFeignClient
public interface RemoteSellerImportService {

    /**
     * 获取销售员最近上传次数
     * @param sellerId 销售员ID
     * @param minute 最近几分钟
     * @return 上传次数
     */
    Integer getSellerImportCount(Long sellerId, Integer minute);

    /**
     * 获取销售员总上传次数
     * @param sellerId 销售员ID
     * @return 总上传次数
     */
    Long getSellerImportTotalCount(Long sellerId);

    /**
     * 根据销售员和链接查询任务，若不存在，则新插入一条任务并返回
     * @param sellerId 销售员ID
     * @param url 链接
     * @return 任务
     */
    SellerImportTaskDto getOrAddSellerImportTask(Long sellerId, String url);

    /**
     * 异步解析销售员导入文章
     * @param url 文章链接
     * @param taskId 任务ID
     * @return true-发送消息成功，false-发送消息失败
     */
    Boolean asyncAnalyzeSellerImport(String url, Long taskId);

    /**
     * 根据ID查询任务
     * @param id 任务ID
     * @return 任务
     */
    SellerImportTaskDto getTaskById(Long id);

    /**
     * 任务完成，绑定文章和销售员关系，更改任务状态
     * @param taskId 任务ID
     * @param sellerId 销售员ID
     * @return true-成功，false-失败
     */
    Boolean completeTask(Long taskId, Long sellerId);



    /**
     * 根据URL获取内容ID
     * @param url URL链接
     * @return 内容ID
     */
    Long getContentIdByUrl(String url);

    /**
     * 更新任务解析结果
     * @param taskId 任务ID
     * @param state 任务状态
     * @see SellerImportTaskStatusEnum
     * @param contentId 内容ID
     * @param message 错误信息
     * @return 0-失败
     */
    int updateTaskAnalyzeResult(Long taskId, Integer state, Long contentId, String message);







    /**
     * 根据销售员和链接查询任务
     * @param sellerId 销售员ID
     * @param url 链接
     * @return 任务
     */
    SellerImportTaskDto getSellerImportTaskBySellerAndUrl(Long sellerId, String url);

}
