package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerContentDto;
import cn.com.duiba.kjy.api.dto.SellerContentSimpleDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SellerContentParams;

import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteSellerContentService {

    /**
     * 文章阅读次数加1, 销售员文章阅读次数加1
     * @param contentId 内容ID
     * @param scId 销售员文章ID
     * @return
     */
    Boolean readNumIncrease(Long contentId, Long scId);

    /**
     * 活动参与人数加1
     * @param sellerId
     * @param activityId
     * @return
     */
    Boolean formNumIncrease(Long sellerId, Long activityId);

    /**
     * 根据销售员ID查询内容
     *
     * @param id 销售员文章ID
     * @return
     */
    SellerContentDto findById(Long id);

    /**
     * 根据销售员ID查询内容
     *
     * @param id 销售员文章ID
     * @return
     */
    SellerContentSimpleDto findSimpleById(Long id);

    /**
     * 显示隐藏我的名片
     *
     * @param scId
     * @param showCard
     * @return
     */
    Boolean showCard(Long scId, Integer showCard);

    /**
     * 生成文章落地页记录
     *
     * @param sellerContentDto
     * @return
     */
    Long getScId(SellerContentDto sellerContentDto);

    /**
     * 分页获取销售发布的文章列表
     *
     * @param sellerContentParams
     * @return
     */
    Page<SellerContentSimpleDto> contentList(SellerContentParams sellerContentParams);

    /**
     * 更新首次访问
     * @param scid
     * @return
     */
    Boolean updateNotFirstVisit(Long scid);

    /**
     * 获取销售员文章的阅读数
     * @param sellerId 销售员ID
     * @param contentIds 销售员内容ID集合
     * @return 内容对应的阅读数
     */
    Map<Long, Long> findReadNumBySellerId(Long sellerId, List<Long> contentIds);

}
