package cn.com.duiba.kjy.api.constant;


import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    DAILY("daily", "早报"),
    POSTER("poster", "海报"),
    AFTERNOON("afternoon", "午后话题"),
    EVENING("evening", "晚安心语"),

    // 访问记录的类型
    SELLER("seller", "销售员名片"),
    OUTER_MARKET("outer_market", "腰封自定义链接"),
    OUTER_EXCLUSIVE("outer_exclusive", "专区自定义链接"),
    ;

    private String code;
    private String desc;

    ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ContentTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ContentTypeEnum type : values()){
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentTypeEnum getByCode(String code){
        ContentTypeEnum result = ENUM_MAP.get(code);
        if(result == null){
           return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals(type, ARTICLE.code) ||
                StringUtils.equals(type, ACTIVITY.code) ||
                StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, POSTER.code);
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals(type, OUTER_MARKET.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals(type, OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals(type, SELLER.code);
    }

}
