package cn.com.duiba.kjy.api.enums.seller;

/**
 * @author zhanghuifeng
 * date 2019-05-17-14:12
 */
public enum WithdrawStatusEnum {

    DEALING(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    ;
    private Integer code;

    private String desc;

    WithdrawStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static WithdrawStatusEnum getByCode(Integer code) {
        for (WithdrawStatusEnum enumVal : WithdrawStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (WithdrawStatusEnum enumVal : WithdrawStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
