package cn.com.duiba.kjy.api.enums.explosioncontent;

import lombok.Getter;

/**
 * 焦虑类型枚举
 * @author xiaotian
 * @date 2020-07-13 17:57
 **/
@Getter
public enum AnxietyEnum {

    CHILD(1,"育儿焦虑","少儿成长投保攻略","你有份育儿资料待领取","了解子女成长过程中常见问题"),
    ASSET(2,"财产焦虑","资产规划投保攻略","开启小白理财第一步","（你有份待理财规划资料待领取）"),
    MIDDLE_AGE(3,"中年焦虑","家庭安全投保攻略","你有份家庭保障资料待领取","守护全家的保障方案"),
    ACCIDENT(4,"意外焦虑","意外防范投保攻略","生活意外早预防","你有份意外保护资料待领取"),
    HEALTH(5,"健康焦虑","健康无忧投保攻略","你有份健康资料待领取","常见慢性病预防方案早知道"),
    OLD(6,"养老焦虑","老年保障投保攻略","老年生活早规划","你有份养老资料待领取")
    ;
    private Integer code;
    private String desc;
    private String materialDesc;
    /**
     * 个人专栏title
     */
    private String columnTitle;

    /**
     * 个人专栏content
     */
    private String columnContent;

    AnxietyEnum(Integer code, String desc,String materialDesc, String columnTitle,String columnContent) {
        this.code = code;
        this.desc = desc;
        this.materialDesc = materialDesc;
        this.columnTitle = columnTitle;
        this.columnContent = columnContent;
    }

    public static AnxietyEnum  getByCode(Integer code){
        for (AnxietyEnum anxietyEnum : AnxietyEnum.values()){
            if(anxietyEnum.getCode().equals(code)){
                return anxietyEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public String getColumnTitle() {
        return columnTitle;
    }

    public String getColumnContent() {
        return columnContent;
    }
}
